/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.tristankechlo.livingthings.config.entity.GiraffeConfig;
import com.tristankechlo.livingthings.entity.ai.BetterMeleeAttackGoal;
import com.tristankechlo.livingthings.entity.misc.IMobVariants;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.LexiconEntries;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;

public class GiraffeEntity
extends Animal
implements NeutralMob,
IMobVariants,
ILexiconEntry {
    private static final EntityDataAccessor<Byte> GIRAFFE_VARIANT = SynchedEntityData.m_135353_(GiraffeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final UniformInt rangedInteger = TimeUtil.m_145020_((int)20, (int)39);
    private int angerTime;
    private UUID angerTarget;

    public GiraffeEntity(EntityType<? extends GiraffeEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public static boolean checkGiraffeSpawnRules(EntityType<GiraffeEntity> animal, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return world.m_8055_(pos.m_7495_()).m_204336_(LivingThingsTags.GIRAFFE_SPAWNABLE_ON) && GiraffeEntity.m_186209_((BlockAndTintGetter)world, (BlockPos)pos);
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob entityIn) {
        GiraffeEntity entityChild = (GiraffeEntity)ModEntityTypes.GIRAFFE.get().m_20615_(this.m_9236_());
        entityChild.setVariant(this.getVariantFromParents((AgeableMob)this, entityIn));
        return entityChild;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        int color1Weight = (Integer)GiraffeConfig.get().color1Weight.get();
        int color2Weight = (Integer)GiraffeConfig.get().color2Weight.get();
        int whiteWeight = (Integer)GiraffeConfig.get().colorWhiteWeight.get();
        byte variant = this.getRandomVariant(this.f_19796_, new byte[]{0, 1, 2}, new int[]{color1Weight, color2Weight, whiteWeight});
        this.setVariant(variant);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, GiraffeConfig.health()).m_22268_(Attributes.f_22279_, GiraffeConfig.movementSpeed()).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22281_, GiraffeConfig.attackDamage());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BetterMeleeAttackGoal((PathfinderMob)this, 1.2, false, GiraffeConfig::canAttack));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.9));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 0.95));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(GIRAFFE_VARIANT, (Object)0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128344_("GiraffeVariant", this.getVariant());
        this.m_21678_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128445_("GiraffeVariant"));
        this.m_147285_(this.m_9236_(), compound);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(LivingThingsTags.GIRAFFE_FOOD);
    }

    public int m_5792_() {
        return GiraffeConfig.maxSpawnedInChunk();
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return size.f_20378_ * 0.98f;
    }

    public int m_6784_() {
        return this.angerTime;
    }

    public void m_7870_(int time) {
        this.angerTime = time;
    }

    public UUID m_6120_() {
        return this.angerTarget;
    }

    public void m_6925_(UUID target) {
        this.angerTarget = target;
    }

    public void m_6825_() {
        this.m_7870_(rangedInteger.m_214085_(this.f_19796_));
    }

    @Override
    public byte getVariant() {
        return (Byte)this.m_20088_().m_135370_(GIRAFFE_VARIANT);
    }

    @Override
    public void setVariant(byte variant) {
        this.m_20088_().m_135381_(GIRAFFE_VARIANT, (Object)variant);
    }

    @Override
    public ResourceLocation getLexiconEntry() {
        return LexiconEntries.GIRAFFE;
    }
}

